﻿//===============================================
// MessageAutoSkipForYumenamakon.js 
//===============================================

/*:ja
 * @plugindesc メッセージの自動送りに音声の再生を加味するプラグインです。
 * @author 村人A
 *
 * @help
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * バージョン情報
 * 
 * 2020/02/22 ver1.2リリース
 * ボイス無しの文章がオート再生できない不具合の修正。
 * 
 * 2020/02/19 ver1.1リリース
 * 自動送りをＯＮにするキーの指定にAキーに対応するようにしました。
 * 
 * 2019/5/26 ver0.93リリース
 * 
 * 2019/5/12 ver0.9リリース
 * 
 * _/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/
 * 
 * ===================================
 * ヘルプ
 * ===================================
 * 
 * SEの長さに合わせてメッセージを自動送りにするプラグインです。
 * 
 * メッセージに使用しているＳＥなのか、そうでないＳＥなのか判別するためにボイスに
 * 使用するＳＥの前にプラグインコマンドにて「ボイスＳＥスタート」と記述し、そうで
 * ないＳＥの前では「ボイスＳＥ終わり」と記述してください。
 * 
 * その後にまたボイスが続く場合は再度「ボイスＳＥスタート」と記述してください。
 * サンプルプロジェクトに例がございますのでそちらをご参照ください。
 * 
 * 自動送りをＯＮにするキーはプラグインパラメータにて指定できます。
 * 初期設定はコントロールキーにしてあります。
 * 
 * キーの記述はrpg_core.jsの2998行目からのInput.keyMapperを参照するか、下記の私の
 * サイトでも紹介しております。
 * 
 * http://www.rpgmaker-script-wiki.xyz/mousekeyevent_kowazamv.php
 * 
 * 
 * @param 自動送りをＯＮにするキーの指定
 * @desc メッセージの自動送りをＯＮにするキーを指定します。
 * @default control
 */

(function() {
	'use strict';
	
    let parameters = PluginManager.parameters('MessageAutoSkipForYumenamakon');
	const _g_autoMessageOnKey = parameters['自動送りをＯＮにするキーの指定'];

	Input.keyMapper[65] = 'A';
	
    //-----------------------------------------------------------------------------
    // PluginCommands
    //-----------------------------------------------------------------------------
    var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
    Game_Interpreter.prototype.pluginCommand = function(command, args){
        _Game_Interpreter_pluginCommand.call(this, command, args);

        if(command === 'ボイスＳＥスタート'){
            $gameSystem.MASFY_startSE = true;
        }
        if(command === 'ボイスＳＥ終わり'){
            $gameSystem.MASFY_startSE = false;
        }
    };
	
	//-----------------------------------------------------------------------------
	// AudioManager
	//
	
    const _alias_AudioManager_playSe = AudioManager.playSe;
	AudioManager.playSe = function(se) {
		_alias_AudioManager_playSe.call(this, se)
		if($gameSystem.MASFY_startSE){
			if (se.name) {$gameSystem.seBuffer = this._seBuffers[this._seBuffers.length-1]};
		}
	};

	//-----------------------------------------------------------------------------
	// Window_Message
	//
	
    const _alias_Window_Message_initialize = Window_Message.prototype.initialize;
	Window_Message.prototype.initialize = function() {
		_alias_Window_Message_initialize.call(this);
		$gameMessage.autoMessageSkip = false;
		this.voiceSeFrame = 0;
	}

    const _alias_Window_Message_startMessage = Window_Message.prototype.startMessage;
	Window_Message.prototype.startMessage = function() {
		_alias_Window_Message_startMessage.call(this);
		if($gameSystem.MASFY_startSE){this.noSEMessgeWaitCount = 10};
	}

    //文章が表示されkey入力待ちの際もskipキーの入力を監視しておく
    const _alias_Window_Message_updateInput = Window_Message.prototype.updateInput;
    Window_Message.prototype.updateInput = function() {
        if(Input.isTriggered(_g_autoMessageOnKey)){
			$gameMessage.autoMessageSkip = !$gameMessage.autoMessageSkip;
		}
		if(this.updateMASFY_update()){return true}
		return _alias_Window_Message_updateInput.call(this);
    };
	
    Window_Message.prototype.updateMASFY_update = function() {
		if(!$gameSystem.MASFY_startSE){return}
		if(this.noSEMessgeWaitCount > 0){
			this.noSEMessgeWaitCount--;
			if(this.noSEMessgeWaitCount == 0 && this.voiceSeFrame == 0){
				if(!this._messageAutoCount){throw new Error('トリアコンタン様のMessageSkip.jsが見つかりません')}
				this.voiceSeFrame = this._messageAutoCount;
			}
		}
		if($gameSystem.seBuffer){
			if($gameSystem.seBuffer._totalTime > 0){
				this.voiceSeFrame = Math.round($gameSystem.seBuffer._totalTime * 60);
				$gameSystem.seBuffer = null;
			}
		}
		if(this.voiceSeFrame > 0){this.voiceSeFrame--};
		if (this.pause && $gameMessage.autoMessageSkip) {
			if(this.voiceSeFrame <= 0){
				this.pause = false;
				this.terminateMessage();
				return true;
			}
		}
		return false;
	}

})();
	